/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8235;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8235.BoxInfo;
import ibm.nways.jdm8235.eui.ApwGroup;
import ibm.nways.jdm8235.eui.ConfigurationAltFolderGroup;
import ibm.nways.jdm8235.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8235.eui.SecurityFolderGroup;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.util.ResourceBundle;

public class Jdm8235
extends JdmBrowser {
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private static String bundleName = "ibm.nways.jdm8235.Resources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private GenModel deviceModel;
    private BoxInfo boxInfo;
    static boolean loggingOn;
    private boolean isDeviceUp = false;
    private boolean AdminPasswordOK = false;
    private String AdminPassword;
    private NavFieldOverride jdm8235DeviceOverrides;
    static final Object[][] jdm8235DeviceFieldOverrides;
    static final Object[][] modelxxx1Overrides;

    public void setAdmPW(String string) {
        this.AdminPassword = string;
    }

    public String getAdmPW() {
        return this.AdminPassword;
    }

    public void setAdmPWFlg(boolean bl) {
        this.AdminPasswordOK = bl;
    }

    public boolean getAdmPWFlg() {
        return this.AdminPasswordOK;
    }

    public String getModelTypeName() {
        return "ibm.nways.jdm8235.model.Jdm8235";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        if (!this.AdminPasswordOK) {
            return graphicPanel;
        }
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        if (loggingOn) {
            System.out.println("jdm8235: getDeviceGraphic - entry.");
        }
        this.displayMsg(Jdm8235.getNLSString("StartGraphic"));
        if (this.deviceModel != null) {
            graphicPanel = this.boxInfo.getDeviceGraphic();
        } else {
            if (loggingOn) {
                System.out.println("jdm8235: Can't draw graphic");
            }
            GraphicContainer graphicContainer = new GraphicContainer();
            Label label = new Label(Jdm8235.getNLSString("NoGraphic"), 1);
            label.setFont(new Font("Arial", 1, 14));
            label.setLocation(new Point(35, -5));
            graphicContainer.add(label);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
        }
        if (loggingOn) {
            System.out.println("jdm8235: Exitting getDeviceGraphic()");
        }
        this.displayMsg(Jdm8235.getNLSString("EndGraphic"));
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (this.getIsApplication()) {
            loggingOn = Log.getLog().getLoggingState();
        }
        if (loggingOn) {
            System.out.println("jdm8235:getNavTreeRoot - entry ");
        }
        if (this.deviceModel != null || this.boxInfo != null) {
            if (loggingOn) {
                System.out.println("jdm8235:redraw request but still need to call dispose");
            }
            this.dispose();
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (loggingOn) {
                System.out.println("jdm8235:getNavTreeRoot deviceModel is NULL!");
            }
            this.rootFolder = new NavigationFolder(Jdm8235.getNLSString("unknown"));
            this.navContext = this.rootFolder.getNavContext();
            return this.rootFolder;
        }
        this.displayMsg(Jdm8235.getNLSString("startBoxInfo"));
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.displayMsg(Jdm8235.getNLSString("endBoxInfo"));
        this.rootFolder = this.boxInfo.getDeviceStatus() == 1 ? new NavigationFolder(Jdm8235.getNLSString("deviceName")) : new NavigationFolder(Jdm8235.getNLSString("unknown"));
        this.navContext = this.rootFolder.getNavContext();
        BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        this.jdm8235DeviceOverrides = new NavFieldOverride(this.navContext, jdm8235DeviceFieldOverrides);
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(Jdm8235.getNLSString("startTree"));
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        try {
            if (this.boxInfo.getDeviceStatus() == 1) {
                if (!this.AdminPasswordOK) {
                    GenModel genModel = (GenModel)this.deviceModel.getComponent("HandCodedApw");
                    ApwGroup apwGroup = new ApwGroup((JdmBrowser)this, genModel);
                    apwGroup.setIsInitiallyExpanded(true);
                    apwGroup.addChildren();
                    this.rootFolder.add((NavigationPoint)apwGroup);
                    NavigationPoint navigationPoint = this.getNavigationTree().findId("ibm.nways.jdm8235.PwPanel");
                    this.navPointSelected(navigationPoint);
                } else {
                    this.buildConfigurationFolder(this.rootFolder, false);
                    this.buildToolsFolder(this.rootFolder);
                }
            } else {
                this.buildConfigurationFolder(this.rootFolder, true);
                this.buildToolsFolder(this.rootFolder);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.displayMsg(Jdm8235.getNLSString("endTree"));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder, boolean bl) {
        GenModel genModel = null;
        GenModel genModel2 = null;
        try {
            if (bl) {
                genModel = (GenModel)this.deviceModel.getComponent("ConfigurationAltFolder");
                ConfigurationAltFolderGroup configurationAltFolderGroup = new ConfigurationAltFolderGroup((JdmBrowser)this, genModel);
                configurationAltFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationAltFolderGroup);
                navigationFolder.add((NavigationPoint)configurationAltFolderGroup);
                return;
            }
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
            genModel2 = (GenModel)this.deviceModel.getComponent("SecurityFolder");
            SecurityFolderGroup securityFolderGroup = new SecurityFolderGroup((JdmBrowser)this, genModel2);
            securityFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityFolderGroup);
            navigationFolder.add((NavigationPoint)securityFolderGroup);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(Jdm8235.getNLSString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(Jdm8235.getNLSString("mibBrowser"), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            WebContext webContext = new WebContext(string);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.only_nhd_url();
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
    }

    public void dispose() {
        if (this.getIsApplication()) {
            loggingOn = Log.getLog().getLoggingState();
        }
        if (loggingOn) {
            System.out.println("jdm8235:Jdm8235.dispose - entry ");
        }
        if (this.boxInfo != null) {
            this.boxInfo.dispose();
            this.boxInfo = null;
        }
        this.rootFolder = null;
        this.tree = null;
        this.navContext = null;
        this.deviceModel = null;
    }

    protected static String getNLSString(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                string2 = myResources.getString(string);
            }
            catch (Exception exception) {
                try {
                    string2 = commonResources.getString(string);
                }
                catch (Exception exception2) {
                    string2 = string;
                    if (!loggingOn) break block4;
                    System.out.println("jdm8235:==> No NLS translation for string " + string);
                }
            }
        }
        return string2;
    }

    public boolean checkLogging() {
        if (this.getIsApplication()) {
            return Log.getLog().getLoggingState();
        }
        return false;
    }

    static {
        jdm8235DeviceFieldOverrides = new Object[0][];
        modelxxx1Overrides = new Object[0][];
    }
}

